//								EJEMPLO 27
//						Autor: Mikel Etxebarria
//			(c) Ingeniera de Microsistemas Programados S.L.
//						www.microcontroladores.com
//								Bilbao 2006
//
//El TMR2. Generacin de periodos y frecuencias
//
//El TMR2 provoca una interrupcin cada vez que se alcance el valor de un periodo (P). La inte-
//rrupcin hace bascular el estado lgico de la lnea RB0, por lo que la frecuencia en esta 
//lnea ser 1/2P.
//
//El periodo P se establece mediante el valor binario que se introduce a travs de los interrup-
//tores E0-E5 conectados a la puerta A, multiplicado por 4.

#include <16f876A.h>

//Ajusta los valores de la palabra de configuracin durante el ensamblaje:
//Proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

#fuses NOPROTECT,NOCPD,NOLVP,NOWDT,XT

// Con estas directivas las funciones "input" y "output_bit" no reprograman
// el pin de la puerta cada vez que son utilizadas. Si no se indica el
// modo fast_io se asume por defecto standard_io el cual reprograma el pin
// siempre antes de ser utilizadas estas funciones.

#use fast_io (A)
#use fast_io (B)
#use delay(clock=4000000)

int	periodo;			//Variable para el periodo
int delay=10;			//Variable para temporizacin

#int_timer2		//Vector de interrupcin del timer 2
tratamiento()	//Funcin de tratamiento del timer 2
{ 
	if (delay == 0)	//Se han producido 10 interrupciones ??
	 {	periodo=(input_a()&0x3f)*4;	//Lee y acondiciona el valor RA0-RA5 para el periodo
		setup_timer_2(t2_div_by_16,periodo,16);	//Ajusta posible nuevo periodo
		output_b(input_b() ^ 0x01);	//RB0 cambia de estado
		delay=10;	//Reponer variable de temporizacin
	}
	else 
		-- delay;	//Decrementa variable de temporizacin
}
	
main()
{  
	SETUP_ADC_PORTS(NO_ANALOGS);//Puerta A Digital
	output_b(0x00);		//Borra salidas
	set_tris_a(0xff);	//Puerta A entrada
	set_tris_b(0x00);	//Puerta B salida	
	enable_interrupts(int_timer2); //Activa interrupcin del TMR2

//El TMR2 emplea un preescaler y un postcaler de 1:16 (total 1:256). Trabajando a una
//frecuencia de 4 MHZ el TMR2 evoluciona cada 16uS (preescaler 1:16). La cuenta avanza hasta
//alcanzar el valor del registro de periodos que se carga con el estado de ((RA5-RA0) * 4), por 16
//(postscaler 1:16). Dicho tiempo escilar entre 256 uS y 65535 uS. Todo ello se repite 10 veces antes de
//que RB0 cambie de estado. En esta lnea tenemos un semi periodo comprendido entre 2,5mS y 655 mS

	periodo=(input_a()&0x3f)*4;		//Lee y acondiciona el valor RA0-RA5 para el periodo
	setup_timer_2(t2_div_by_16,periodo,16);	//TMR2 pre y postcaler 1:16, periodo de RA0-RA5
	set_timer2(0x00);	//Inicia el TMR2
	enable_interrupts(global);	//Habilita interrupciones

	while(1)
	{	
	}
}	
